/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: VARANStack_Public.h $
   Last Modification:
    $Author: Dimitar $
    $Modtime: 31.07.06 9:55 $
    $Revision: 12 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    VARAN CLIENT
    public

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------

**************************************************************************************/
/**
 * @file VARANStack_Public.h
 *  VARAN CLIENT - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __VARAN_CLIENT_PUBLIC_H
#define __VARAN_CLIENT_PUBLIC_H


#define VARAN_CLIENT_QUEUE_NAME               "QUE_VRN_CLIENT"

/*************************************************************************************/
/* Packet command defines                                                            */
/*************************************************************************************/

#define VARAN_CLIENT_CMD_INIT_REQ             (0x00006F00)
#define VARAN_CLIENT_CMD_INIT_CNF             (0x00006F01)

#define VARAN_CLIENT_CMD_RESET_REQ            (0x00006F02)
#define VARAN_CLIENT_CMD_RESET_CNF            (0x00006F03)

#define VARAN_CLIENT_CMD_SET_INPUT_REQ        (0x00006F04)
#define VARAN_CLIENT_CMD_SET_INPUT_CNF        (0x00006F05)

#define VARAN_CLIENT_CMD_GET_OUTPUT_REQ       (0x00006F06)
#define VARAN_CLIENT_CMD_GET_OUTPUT_CNF       (0x00006F07)

#define VARAN_CLIENT_CMD_CHANGE_STATE_REQ     (0x00006F08)
#define VARAN_CLIENT_CMD_CHANGE_STATE_CNF     (0x00006F09)

#define VARAN_CLIENT_CMD_EVENT_IND            (0x00006F0A)
#define VARAN_CLIENT_CMD_EVENT_RES            (0x00006F0B)

#define VARAN_CLIENT_CMD_CHECK_CFG_REQ        (0x00006F0E)
#define VARAN_CLIENT_CMD_CHECK_CFG_CNF        (0x00006F0F)

#define VARAN_CLIENT_CMD_GET_DIAG_REQ         (0x00006F10)
#define VARAN_CLIENT_CMD_GET_DIAG_CNF         (0x00006F11)



/*************************************************************************************/
/* Packet parameter defines for VARAN_CLIENT_PCK_INIT_REQ                            */
/*************************************************************************************/

/** used @ ulVendorId */
#define VARAN_CLIENT_VENDOR_ID_MIN            (0x00000000)
#define VARAN_CLIENT_VENDOR_ID_MAX            (0xFFFFFFFF)
#define VARAN_CLIENT_VENDOR_ID_DEF            (0x0000001D) /* Hilscher Vendor ID */

/** used @ ulDeviceId */
#define VARAN_CLIENT_DEVICE_ID_MIN            (0x00000000)
#define VARAN_CLIENT_DEVICE_ID_MAX            (0xFFFFFFFF)
#define VARAN_CLIENT_DEVICE_ID_VEB022         (0x000003FD)
#define VARAN_CLIENT_DEVICE_ID_VEB021         (0x000003F0)

/** used @ ulLicenceNumber */
#define VARAN_CLIENT_LICENCE_NUM_MIN          (0x00000000)
#define VARAN_CLIENT_LICENCE_NUM_MAX          (0xFFFFFFFF)
#define VARAN_CLIENT_LICENCE_NUM_DEF          (0x00000000)

/** used @ ulLicenceNumber */
#define VARAN_CLIENT_REVISION_NUM_MIN         (0x00000000)
#define VARAN_CLIENT_REVISION_NUM_MAX         (0xFFFFFFFF)
#define VARAN_CLIENT_REVISION_NUM_DEF         (0x00000000)

/** used @ abVendorName[] */
#define VARAN_CLIENT_VENDOR_NAME_DEF          "Hilscher GmbH"

/** used @ abVendorName[] */
#define VARAN_CLIENT_DEVICE_NAME_DEF          "netX"

/** used @ ulSerialNumber */
#define VARAN_CLIENT_SERIAL_NUM_MIN           (0x00000000)
#define VARAN_CLIENT_SERIAL_NUM_MAX           (0xFFFFFFFF)
#define VARAN_CLIENT_SERIAL_NUM_DEF           (0x00000000)

/** used @ ulOrderNumber */
#define VARAN_CLIENT_ORDER_NUM_MIN            (0x00000000)
#define VARAN_CLIENT_ORDER_NUM_MAX            (0xFFFFFFFF)
#define VARAN_CLIENT_ORDER_NUM_DEF            (0x00000000)


/** used @ ulMemArea1ReadOffset + ulMemArea1WriteOffset*/
#define VARAN_CLIENT_MEM_AREA_1_OFFSET_MIN    (0x0000)
#define VARAN_CLIENT_MEM_AREA_1_OFFSET_MAX    (0xFFFF)
#define VARAN_CLIENT_MEM_AREA_1_OFFSET_DEF    (0x2000)

/** used @ ulMemArea1ReadSize + ulMemArea1WriteSize*/
#define VARAN_CLIENT_MEM_AREA_1_RW_SIZE_MIN   (0)
#define VARAN_CLIENT_MEM_AREA_1_RW_SIZE_MAX   (128)
#define VARAN_CLIENT_MEM_AREA_1_RW_SIZE_DEF   (128)

/** used @ ulMemArea2ReadOffset + ulMemArea2WriteOffset*/
#define VARAN_CLIENT_MEM_AREA_2_OFFSET_MIN    (0x0000)
#define VARAN_CLIENT_MEM_AREA_2_OFFSET_MAX    (0xFFFF)
#define VARAN_CLIENT_MEM_AREA_2_OFFSET_DEF    (0xFFFF)

/** used @ ulMemArea2ReadSize + ulMemArea2WriteSize*/
#define VARAN_CLIENT_MEM_AREA_2_RW_SIZE_MIN   (0)
#define VARAN_CLIENT_MEM_AREA_2_RW_SIZE_MAX   (128)
#define VARAN_CLIENT_MEM_AREA_2_RW_SIZE_DEF   (0)

/** used @ ulConfigFlags */
#define VARAN_CLIENT_MSK_CFG_FLAG_EN_EMAC     (0x00000001)
#define VARAN_CLIENT_MSK_CFG_FLAG_EN_MEM2     (0x00000002)
#define VARAN_CLIENT_MSK_CFG_FLAG_RESERVED    (0xFFFFFFFC)

/** used @ ulClientWdgTime */
#define VARAN_CLIENT_WATCHDOG_TIME_MIN        (0)    /* Min. client watchdog time in ms (0 -> diabled)  */
#define VARAN_CLIENT_WATCHDOG_TIME_MAX        (130)  /* Max. client watchdog time in ms                 */
#define VARAN_CLIENT_WATCHDOG_TIME_DEF        (130)  /* Default client watchdog time in ms              */


/** used @ ulSyncOutPulsLen */
#define VARAN_CLIENT_SYNC_OUT_PULS_MIN        (10)
#define VARAN_CLIENT_SYNC_OUT_PULS_MAX        (0xFFFFFFFF)
#define VARAN_CLIENT_SYNC_OUT_PULS_DEF        (100)


/** used @ ulSyncOut0Mode & ulSyncOut1Mode */
#define VARAN_CLIENT_SYNC_MODE_DISABLE        (0)    /* This output is not available                     */
#define VARAN_CLIENT_SYNC_MODE_TI             (3)    /* Time for data in valid                           */
#define VARAN_CLIENT_SYNC_MODE_T0             (4)    /* Time for data out valid                          */
#define VARAN_CLIENT_SYNC_MODE_TIO            (5)    /* Time for data in/out valid                       */

/** used @ ulSyncOut0Flags & ulSyncOut1Flags */
#define VARAN_CLIENT_MSK_SYNC_OUT_OE          (0x00000001)
#define VARAN_CLIENT_MSK_SYNC_OUT_ACTIVE_HIGH (0x00000002)
#define VARAN_CLIENT_MSK_SYNC_OUT_RESERVED    (0xFFFFFFFC)



/** used @ ulMemArea  */
#define VARAN_CLIENT_MEMORY_AREA_1             (0)
#define VARAN_CLIENT_MEMORY_AREA_2             (1)

/** used @ ulDataState */
#define VARAN_CLIENT_DATA_STATE_OK             (0x00000001) /* Data are invalid                          */
#define VARAN_CLIENT_DATA_STATE_NOK            (0x00000000) /* Data are valid                            */

/** maximum buffer size for varan IO data */
#define VARAN_CLIENT_BUFFER_SIZE               (128)


/** maximum memory areas number for varan IO data */
#define VARAN_CLIENT_MEMORY_AREAS_COUNT        (2)

/** maximums vendor name length used @ abVendorName */
#define VARAN_CLIENT_VENDOR_NAME_MAX_LEN       (16)

/** maximums device name length used @ abDeviceName */
#define VARAN_CLIENT_DEV_NAME_MAX_LEN          (16)

/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task.
 * @{
 */


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__VARAN_CLIENT_PACKET)
#endif

typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_STACK_DATA_INIT_REQ_Ttag{

  /** Device Identity configuration */
  TLR_UINT32  ulVendorId;              /* VendorID              */
  TLR_UINT32  ulDeviceId;              /* DeviceID              */
  TLR_UINT32  ulLicenseNumber;         /* LicNumber             */
  TLR_UINT32  ulProductRevision;       /* Revision              */
  TLR_UINT8   abVendorName[64];        /* Vendor Name           */
  TLR_UINT8   abDeviceName[64];        /* Device Name           */
  TLR_UINT32  ulSerialNumber;          /* Serial Number         */
  TLR_UINT32  ulOrderNumber;           /* Order Number          */
  TLR_UINT8   abIdReserved[8];         /* Resreved              */

  /**Protocol Process Data configuration */
  TLR_UINT32  ulMemArea1ReadOffset;    /* MemArea1 Read  Offset */
  TLR_UINT32  ulMemArea1ReadSize;      /* MemArea1 Read  Size   */
  TLR_UINT32  ulMemArea1WriteOffset;   /* MemArea1 Write Offset */
  TLR_UINT32  ulMemArea1WriteSize;     /* MemArea1 Write Size   */

  TLR_UINT32  ulMemArea2ReadOffset;    /* MemArea2 Read  Offset */
  TLR_UINT32  ulMemArea2ReadSize;      /* MemArea2 Read  Size   */
  TLR_UINT32  ulMemArea2WriteOffset;   /* MemArea2 Write Offset */
  TLR_UINT32  ulMemArea2WriteSize;     /* MemArea2 Write Size   */

  /** Protocol Misc configuration */
  TLR_UINT32  ulConfigFlags;           /* Configuration flags   */
  TLR_UINT32  ulClientWdgTime;         /* Client watchdog time  */
  TLR_UINT8   abReserved[32] ;      /* Reserved              */

  /** Protocol SYNC configuration */
  TLR_UINT32  ulSyncOutPulsLen;        /* SYNC OUT puls length  */
  TLR_UINT32  ulSyncOut0Mode;          /* SYNC OUT 0 ID         */
  TLR_UINT32  ulSyncOut0Flags;         /* SYNC OUT 0 Flags      */
  TLR_UINT32  ulSyncOut1Mode;          /* SYNC OUT 1 ID         */
  TLR_UINT32  ulSyncOut1Flags;         /* SYNC OUT 1 Flags      */

  /** Protocol EMAC configuration */
  TLR_UINT8   abEmacReserved[16] ;     /* Reserved for EMAC cfg  */

}VARAN_CLIENT_STACK_DATA_INIT_REQ_T;


typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_DATA_INIT_CNF_Ttag{
  TLR_UINT32 ulTriBufHandleMemArea1Send;
  TLR_UINT32 ulTriBufHandleMemArea1Recv;
  TLR_UINT32 ulTriBufHandleMemArea2Send;
  TLR_UINT32 ulTriBufHandleMemArea2Recv;
}VARAN_CLIENT_PCK_DATA_INIT_CNF_T;


#include "VARANStack_Diagstructdef.h"

/********************************************************
 *  VARAN Slave - Packet - Init.Req/Cnf
 ********************************************************/
#define  VARAN_CLIENT_PCK_INIT_REQ_T_LEN                 (sizeof(VARAN_CLIENT_STACK_DATA_INIT_REQ_T))
typedef __PACKED_PRE struct __PACKED_POST  VARAN_CLIENT_PCK_INIT_REQ_Ttag{
  TLR_PACKET_HEADER_T           tHead;
  VARAN_CLIENT_STACK_DATA_INIT_REQ_T  tData;
}VARAN_CLIENT_PCK_INIT_REQ_T;

 #define  VARAN_CLIENT_PCK_INIT_CNF_T_LEN                 (sizeof(VARAN_CLIENT_PCK_DATA_INIT_CNF_T))
typedef __PACKED_PRE struct __PACKED_POST  VARAN_CLIENT_PCK_INIT_CNF_Ttag{
  TLR_PACKET_HEADER_T           tHead;
  VARAN_CLIENT_PCK_DATA_INIT_CNF_T  tData;
}VARAN_CLIENT_PCK_INIT_CNF_T;

/********************************************************
 *  Varan CLIENT - Packet - Check configuration pack Req/Cnf
 ********************************************************/
#define VARAN_CLIENT_PCK_CHECK_CONFIGURATION_REQ_SIZE    (sizeof(VARAN_CLIENT_STACK_DATA_INIT_REQ_T))
typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_CHECK_CONFIGURATION_REQ_Ttag{
  TLR_PACKET_HEADER_T           tHead;
  VARAN_CLIENT_STACK_DATA_INIT_REQ_T  tData;
}VARAN_CLIENT_PCK_CHECK_CONFIGURATION_REQ_T;

#define VARAN_CLIENT_PCK_CHECK_CONFIGURATION_CNF_SIZE     (0)
typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_CHECK_CONFIGURATION_CNF_Ttag{
  TLR_PACKET_HEADER_T           tHead;
}VARAN_CLIENT_PCK_CHECK_CONFIGURATION_CNF_T;

/********************************************************
 *  Varan CLIENT - Data - SetInput.Req/Cnf
 ********************************************************/
typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_DATA_SET_INPUT_REQ_Ttag{
  TLR_UINT32 ulMemArea;
  TLR_UINT32 ulReserved;
  TLR_UINT32 ulLen;
  TLR_UINT8  abData[VARAN_CLIENT_BUFFER_SIZE];
}VARAN_CLIENT_PCK_DATA_SET_INPUT_REQ_T;

#define  VARAN_CLIENT_PCK_SET_INPUT_REQ_SIZE       (sizeof(VARAN_CLIENT_PCK_DATA_SET_INPUT_REQ_T)-VARAN_CLIENT_BUFFER_SIZE) /* + 1.128 */
typedef __PACKED_PRE struct __PACKED_POST  VARAN_CLIENT_PCK_SET_INPUT_REQ_Ttag{
  TLR_PACKET_HEADER_T                tHead;
  VARAN_CLIENT_PCK_DATA_SET_INPUT_REQ_T  tData;
}VARAN_CLIENT_PCK_SET_INPUT_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_DATA_SET_INPUT_CNF_Ttag{
  TLR_UINT32 ulMemArea;
  TLR_UINT32 ulReserved;
  TLR_UINT32 ulLen;
}VARAN_CLIENT_PCK_DATA_SET_INPUT_CNF_T;

#define  VARAN_CLIENT_PCK_SET_INPUT_CNF_SIZE       (sizeof(VARAN_CLIENT_PCK_DATA_SET_INPUT_CNF_T))
typedef __PACKED_PRE struct __PACKED_POST  VARAN_CLIENT_PCK_SET_INPUT_CNF_Ttag{
  TLR_PACKET_HEADER_T                tHead;
  VARAN_CLIENT_PCK_DATA_SET_INPUT_CNF_T  tData;
}VARAN_CLIENT_PCK_SET_INPUT_CNF_T;

/********************************************************
 *  Varan CLIENT - Data - GetOutput.Req/Cnf
 ********************************************************/
typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_DATA_GET_OUTPUT_REQ_Ttag{
  TLR_UINT32 ulMemArea;
  TLR_UINT32 ulReserved;
  TLR_UINT32 ulLen;
}VARAN_CLIENT_PCK_DATA_GET_OUTPUT_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_DATA_GET_OUTPUT_CNF_Ttag{
  TLR_UINT32 ulMemArea;
  TLR_UINT32 ulDataState;
  TLR_UINT32 ulLen;
  TLR_UINT8  abData[VARAN_CLIENT_BUFFER_SIZE];
}VARAN_CLIENT_PCK_DATA_GET_OUTPUT_CNF_T;


#define  VARAN_CLIENT_PCK_GET_OUTPUT_REQ_SIZE       (sizeof(VARAN_CLIENT_PCK_DATA_GET_OUTPUT_REQ_T))
typedef __PACKED_PRE struct __PACKED_POST  VARAN_CLIENT_PCK_GET_OUTPUT_REQ_Ttag{
  TLR_PACKET_HEADER_T                tHead;
  VARAN_CLIENT_PCK_DATA_GET_OUTPUT_REQ_T tData;
}VARAN_CLIENT_PCK_GET_OUTPUT_REQ_T;


#define  VARAN_CLIENT_PCK_GET_OUTPUT_CNF_SIZE       (sizeof(VARAN_CLIENT_PCK_DATA_GET_OUTPUT_CNF_T)-VARAN_CLIENT_BUFFER_SIZE)  /* + 1.128 */
typedef __PACKED_PRE struct __PACKED_POST  VARAN_CLIENT_PCK_GET_OUTPUT_CNF_Ttag{
  TLR_PACKET_HEADER_T                 tHead;
  VARAN_CLIENT_PCK_DATA_GET_OUTPUT_CNF_T  tData;
}VARAN_CLIENT_PCK_GET_OUTPUT_CNF_T;


/********************************************************
 *  Varan CLIENT - Packet - Reset.Req/Cnf
 ********************************************************/
#define  VARAN_CLIENT_PCK_RESET_REQ_SIZE       (0)
typedef __PACKED_PRE struct __PACKED_POST  VARAN_CLIENT_PCK_RESET_REQ_Ttag{
  TLR_PACKET_HEADER_T     tHead;
}VARAN_CLIENT_PCK_RESET_REQ_T;

#define  VARAN_CLIENT_PCK_RESET_CNF_SIZE       (0)
typedef __PACKED_PRE struct __PACKED_POST  VARAN_CLIENT_PCK_RESET_CNF_Ttag{
  TLR_PACKET_HEADER_T     tHead;
}VARAN_CLIENT_PCK_RESET_CNF_T;

/********************************************************
 *  Varan CLIENT - Packet - Change State.Req/Cnf
 ********************************************************/

#define VARAN_CLIENT_STOP_COMM  (1)
#define VARAN_CLIENT_START_COMM   (2)

typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_CHANGE_STATE_DATAtag{
  TLR_UINT32 ulState;
}VARAN_CLIENT_PCK_CHANGE_STATE_DATA;

#define VARAN_CLIENT_PCK_CHANGE_STATE_REQ_SIZE     (sizeof(VARAN_CLIENT_PCK_CHANGE_STATE_DATA))
typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_CHANGE_STATE_REQ_Ttag{
  TLR_PACKET_HEADER_T                 tHead;
  VARAN_CLIENT_PCK_CHANGE_STATE_DATA      tData;
}VARAN_CLIENT_PCK_CHANGE_STATE_REQ_T;


#define VARAN_CLIENT_PCK_CHANGE_STATE_CNF_SIZE     (sizeof(VARAN_CLIENT_PCK_CHANGE_STATE_DATA))
typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_CHANGE_STATE_CNF_Ttag{
  TLR_PACKET_HEADER_T                 tHead;
  VARAN_CLIENT_PCK_CHANGE_STATE_DATA      tData;
}VARAN_CLIENT_PCK_CHANGE_STATE_CNF_T;

/*************************************************************************/

/********************************************************
 *  Varan CLIENT - Packet - Change of state.Ind/Res
 ********************************************************/

#define VRN_STATE_COMM_ACTIVE                      (0x00000001)
#define VRN_STATE_COMM_INACTIVE                    (0x00000002)
#define VRN_STATE_COMM_ERROR                       (0x00000003)
#define VRN_STATE_COMM_NOT_RELEASED                (0x00000004)
#define VRN_STATE_COMM_TIME_LIMIT_REACHED          (0x00000005)


typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_EVENT_DATA_Ttag{
  TLR_UINT32 ulState;
}VARAN_CLIENT_EVENT_DATA_T;

#define VARAN_CLIENT_EVENT_IND_SIZE     (sizeof(VARAN_CLIENT_EVENT_DATA_T))
typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_EVENT_IND_Ttag{
  TLR_PACKET_HEADER_T                 tHead;
  VARAN_CLIENT_EVENT_DATA_T           tData;
}VARAN_CLIENT_PCK_EVENT_IND_T;


#define VARAN_CLIENT_EVENT_RES_SIZE               (0)
typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_EVENT_RES_Ttag{
  TLR_PACKET_HEADER_T                 tHead;
}VARAN_CLIENT_PCK_EVENT_RES_T;

/*************************************************************************/

/********************************************************
 *  Varan CLIENT - Packet - Get Diagnosis.Req/Cnf
 ********************************************************/

#define  DIAG_EXT                                  (1)
#define  DIAG_HAL                                  (2)

typedef __PACKED_PRE struct __PACKED_POST VARANAPP_PCK_DIAGTYPE_Ttag{
  TLR_UINT32 ulDiagID;
}VARAN_CLIENT_PCK_GET_DIAG_ID_T;

#define VARAN_CLIENT_PCK_GET_DIAG_REQ_T_SIZE     (sizeof(VARAN_CLIENT_PCK_GET_DIAG_ID_T))
typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_GET_DIAG_REQ_Ttag{
  TLR_PACKET_HEADER_T               tHead;
  VARAN_CLIENT_PCK_GET_DIAG_ID_T    tData;
}VARAN_CLIENT_PCK_GET_DIAG_REQ_T;

typedef union{
  VARAN_CLIENT_EXT_DIAG_T     tExtDiag;
  VARAN_CLIENT_HAL_DIAG_T     tHALDiag;
}VARAN_CLIENT_DIAG_DATA_U;

typedef struct{
  TLR_UINT32                ulDiagID;
  VARAN_CLIENT_DIAG_DATA_U  uDiagnosis;
}VARAN_CLIENT_PCK_GET_DIAG_DATA_T;


#define VARAN_CLIENT_PCK_GET_DIAG_EXT_CNF_T_SIZE     (sizeof(VARAN_CLIENT_EXT_DIAG_T) + sizeof(TLR_UINT32))
#define VARAN_CLIENT_PCK_GET_DIAG_HAL_CNF_T_SIZE     (sizeof(VARAN_CLIENT_HAL_DIAG_T) + sizeof(TLR_UINT32))

typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_PCK_GET_DIAG_CNF_Ttag{
  TLR_PACKET_HEADER_T                 tHead;
  VARAN_CLIENT_PCK_GET_DIAG_DATA_T    tData;
}VARAN_CLIENT_PCK_GET_DIAG_CNF_T;


#endif /* #ifndef __VARAN_CLIENT_PUBLIC_H */
